/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.api.iface.IColored;
import committee.nova.mods.avaritia.client.model.CosmicModelLoader;
import committee.nova.mods.avaritia.client.model.HaloModelLoader;
import committee.nova.mods.avaritia.client.model.InfinityArmorModel;
import committee.nova.mods.avaritia.client.render.tile.CompressedChestRenderer;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.util.client.ColorUtils;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AvaritiaClient {
    public static final ModelLayerLocation COMPRESSED_CHEST = new ModelLayerLocation(Static.rl("compressed_chest"), "main");
    public static final ModelLayerLocation COMPRESSED_CHEST_LEFT = new ModelLayerLocation(Static.rl("compressed_chest_left"), "main");
    public static final ModelLayerLocation COMPRESSED_CHEST_RIGHT = new ModelLayerLocation(Static.rl("compressed_chest_right"), "main");

    @SubscribeEvent
    public static void clientSetUp(FMLClientSetupEvent event) {
        ModEntities.onClientSetup();
        ModMenus.onClientSetup();
        ModTileEntities.onClientSetup();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRegisterShaders(RegisterShadersEvent event) {
        AvaritiaShaders.onRegisterShaders(event);
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(COMPRESSED_CHEST, CompressedChestRenderer::createSingleBodyLayer);
        event.registerLayerDefinition(COMPRESSED_CHEST_LEFT, CompressedChestRenderer::createDoubleBodyLeftLayer);
        event.registerLayerDefinition(COMPRESSED_CHEST_RIGHT, CompressedChestRenderer::createDoubleBodyRightLayer);
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new IColored.ItemColors(), new ItemLike[]{(ItemLike)ModItems.singularity.get()});
        event.register((stack, index) -> AvaritiaClient.getCurrentRainbowColor(), new ItemLike[]{(ItemLike)ModItems.eternal_singularity.get()});
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
    }

    @SubscribeEvent
    public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("cosmic", (IGeometryLoader)CosmicModelLoader.INSTANCE);
        event.register("halo", (IGeometryLoader)HaloModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void addPlayerLayer(EntityRenderersEvent.AddLayers event) {
        AvaritiaClient.addLayer(event, "default");
        AvaritiaClient.addLayer(event, "slim");
    }

    private static void addLayer(EntityRenderersEvent.AddLayers e, String s) {
        LivingEntityRenderer entityRenderer = e.getSkin(s);
        entityRenderer.m_115326_((RenderLayer)new InfinityArmorModel.PlayerRender((RenderLayerParent<Player, PlayerModel<Player>>)entityRenderer));
    }

    public static int getCurrentRainbowColor() {
        float hue = (float)(System.currentTimeMillis() % 18000L) / 18000.0f;
        return ColorUtils.HSBToRGB(hue, 1.0f, 1.0f);
    }
}

